/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.Encodings;
import com.sun.org.apache.xml.internal.serializer.ToStream;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ToTextStream
extends ToStream {
    @Override
    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushPending();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending();
        try {
            if (this.inTemporaryOutputState()) {
                this.m_writer.write(cArray, n, n2);
            } else {
                this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
            }
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl) throws IOException, SAXException {
        String string = this.getEncoding();
        Writer writer = this.m_writer;
        int n3 = n + n2;
        int n4 = 10;
        for (int i = n; i < n3; ++i) {
            String string2;
            char c = cArray[i];
            if ('\n' == c && bl) {
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                continue;
            }
            if (this.m_encodingInfo.isInEncoding(c)) {
                writer.write(c);
                continue;
            }
            if (Encodings.isHighUTF16Surrogate(c)) {
                int n5 = this.writeUTF16Surrogate(c, cArray, i, n3);
                if (n5 != 0) {
                    string2 = Integer.toString(n5);
                    String string3 = Utils.messages.createMessage("ER_ILLEGAL_CHARACTER", new Object[]{string2, string});
                    System.err.println(string3);
                }
                ++i;
                continue;
            }
            if (string != null) {
                writer.write(38);
                writer.write(35);
                writer.write(Integer.toString(c));
                writer.write(59);
                String string4 = Integer.toString(c);
                string2 = Utils.messages.createMessage("ER_ILLEGAL_CHARACTER", new Object[]{string4, string});
                System.err.println(string2);
                continue;
            }
            writer.write(c);
        }
    }

    @Override
    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n, n2, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    @Override
    public void comment(String string) throws SAXException {
        int n = string.length();
        if (n > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, n);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n, n2);
        }
    }

    @Override
    public void entityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endElement(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3) throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    @Override
    public void characters(String string) throws SAXException {
        int n = string.length();
        if (n > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_charsBuff, 0);
        this.characters(this.m_charsBuff, 0, n);
    }

    @Override
    public void addAttribute(String string, String string2) {
    }

    @Override
    public void addUniqueAttribute(String string, String string2, int n) throws SAXException {
    }

    @Override
    public boolean startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        return false;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    @Override
    public void flushPending() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
    }
}

