/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.ElementFactory;
import com.sun.xml.internal.messaging.saaj.soap.name.NameImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SOAPFactoryImpl
extends SOAPFactory {
    protected static final Logger log = Logger.getLogger("com.sun.xml.internal.messaging.saaj.soap", "com.sun.xml.internal.messaging.saaj.soap.LocalStrings");

    protected abstract SOAPDocumentImpl createDocument();

    @Override
    public SOAPElement createElement(String string) throws SOAPException {
        if (string == null) {
            log.log(Level.SEVERE, "SAAJ0567.soap.null.input", new Object[]{"tagName", "SOAPFactory.createElement"});
            throw new SOAPException("Null tagName argument passed to createElement");
        }
        return ElementFactory.createElement(this.createDocument(), NameImpl.createFromTagName(string));
    }

    @Override
    public SOAPElement createElement(Name name) throws SOAPException {
        if (name == null) {
            log.log(Level.SEVERE, "SAAJ0567.soap.null.input", new Object[]{"name", "SOAPFactory.createElement"});
            throw new SOAPException("Null name argument passed to createElement");
        }
        return ElementFactory.createElement(this.createDocument(), name);
    }

    @Override
    public SOAPElement createElement(QName qName) throws SOAPException {
        if (qName == null) {
            log.log(Level.SEVERE, "SAAJ0567.soap.null.input", new Object[]{"qname", "SOAPFactory.createElement"});
            throw new SOAPException("Null qname argument passed to createElement");
        }
        return ElementFactory.createElement(this.createDocument(), qName);
    }

    @Override
    public SOAPElement createElement(String string, String string2, String string3) throws SOAPException {
        if (string == null) {
            log.log(Level.SEVERE, "SAAJ0567.soap.null.input", new Object[]{"localName", "SOAPFactory.createElement"});
            throw new SOAPException("Null localName argument passed to createElement");
        }
        return ElementFactory.createElement(this.createDocument(), string, string2, string3);
    }

    @Override
    public Name createName(String string, String string2, String string3) throws SOAPException {
        if (string == null) {
            log.log(Level.SEVERE, "SAAJ0567.soap.null.input", new Object[]{"localName", "SOAPFactory.createName"});
            throw new SOAPException("Null localName argument passed to createName");
        }
        return NameImpl.create(string, string2, string3);
    }

    @Override
    public Name createName(String string) throws SOAPException {
        if (string == null) {
            log.log(Level.SEVERE, "SAAJ0567.soap.null.input", new Object[]{"localName", "SOAPFactory.createName"});
            throw new SOAPException("Null localName argument passed to createName");
        }
        return NameImpl.createFromUnqualifiedName(string);
    }

    @Override
    public SOAPElement createElement(Element element) throws SOAPException {
        if (element == null) {
            return null;
        }
        return this.convertToSoapElement(element);
    }

    private SOAPElement convertToSoapElement(Element element) throws SOAPException {
        Node node;
        if (element instanceof SOAPElement) {
            return (SOAPElement)element;
        }
        SOAPElement sOAPElement = this.createElement(element.getLocalName(), element.getPrefix(), element.getNamespaceURI());
        Document document = sOAPElement.getOwnerDocument();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            node = (Attr)document.importNode(attr, true);
            sOAPElement.setAttributeNodeNS((Attr)node);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            Node node2 = document.importNode(node, true);
            sOAPElement.appendChild(node2);
        }
        return sOAPElement;
    }

    @Override
    public Detail createDetail() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SOAPFault createFault(String string, QName qName) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SOAPFault createFault() throws SOAPException {
        throw new UnsupportedOperationException();
    }
}

