/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.sax;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import com.sun.xml.internal.org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import java.io.IOException;
import java.util.Map;

public class AttributesHolder
implements EncodingAlgorithmAttributes {
    private static final int DEFAULT_CAPACITY = 8;
    private Map _registeredEncodingAlgorithms;
    private int _attributeCount;
    private QualifiedName[] _names = new QualifiedName[8];
    private String[] _values = new String[8];
    private String[] _algorithmURIs = new String[8];
    private int[] _algorithmIds = new int[8];
    private Object[] _algorithmData = new Object[8];

    public AttributesHolder() {
    }

    public AttributesHolder(Map map) {
        this();
        this._registeredEncodingAlgorithms = map;
    }

    @Override
    public final int getLength() {
        return this._attributeCount;
    }

    @Override
    public final String getLocalName(int n) {
        return this._names[n].localName;
    }

    @Override
    public final String getQName(int n) {
        return this._names[n].getQNameString();
    }

    @Override
    public final String getType(int n) {
        return "CDATA";
    }

    @Override
    public final String getURI(int n) {
        return this._names[n].namespaceName;
    }

    @Override
    public final String getValue(int n) {
        String string = this._values[n];
        if (string != null) {
            return string;
        }
        if (this._algorithmData[n] == null || this._algorithmIds[n] >= 32 && this._registeredEncodingAlgorithms == null) {
            return null;
        }
        try {
            this._values[n] = this.convertEncodingAlgorithmDataToString(this._algorithmIds[n], this._algorithmURIs[n], this._algorithmData[n]).toString();
            return this._values[n];
        }
        catch (IOException iOException) {
            return null;
        }
        catch (FastInfosetException fastInfosetException) {
            return null;
        }
    }

    @Override
    public final int getIndex(String string) {
        int n = string.indexOf(58);
        String string2 = "";
        String string3 = string;
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        for (n = 0; n < this._attributeCount; ++n) {
            QualifiedName qualifiedName = this._names[n];
            if (!string3.equals(qualifiedName.localName) || !string2.equals(qualifiedName.prefix)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public final String getType(String string) {
        int n = this.getIndex(string);
        if (n >= 0) {
            return "CDATA";
        }
        return null;
    }

    @Override
    public final String getValue(String string) {
        int n = this.getIndex(string);
        if (n >= 0) {
            return this._values[n];
        }
        return null;
    }

    @Override
    public final int getIndex(String string, String string2) {
        for (int i = 0; i < this._attributeCount; ++i) {
            QualifiedName qualifiedName = this._names[i];
            if (!string2.equals(qualifiedName.localName) || !string.equals(qualifiedName.namespaceName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n >= 0) {
            return "CDATA";
        }
        return null;
    }

    @Override
    public final String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n >= 0) {
            return this._values[n];
        }
        return null;
    }

    public final void clear() {
        for (int i = 0; i < this._attributeCount; ++i) {
            this._values[i] = null;
            this._algorithmData[i] = null;
        }
        this._attributeCount = 0;
    }

    @Override
    public final String getAlgorithmURI(int n) {
        return this._algorithmURIs[n];
    }

    @Override
    public final int getAlgorithmIndex(int n) {
        return this._algorithmIds[n];
    }

    @Override
    public final Object getAlgorithmData(int n) {
        return this._algorithmData[n];
    }

    @Override
    public String getAlpababet(int n) {
        return null;
    }

    @Override
    public boolean getToIndex(int n) {
        return false;
    }

    public final void addAttribute(QualifiedName qualifiedName, String string) {
        if (this._attributeCount == this._names.length) {
            this.resize();
        }
        this._names[this._attributeCount] = qualifiedName;
        this._values[this._attributeCount++] = string;
    }

    public final void addAttributeWithAlgorithmData(QualifiedName qualifiedName, String string, int n, Object object) {
        if (this._attributeCount == this._names.length) {
            this.resize();
        }
        this._names[this._attributeCount] = qualifiedName;
        this._values[this._attributeCount] = null;
        this._algorithmURIs[this._attributeCount] = string;
        this._algorithmIds[this._attributeCount] = n;
        this._algorithmData[this._attributeCount++] = object;
    }

    public final QualifiedName getQualifiedName(int n) {
        return this._names[n];
    }

    public final String getPrefix(int n) {
        return this._names[n].prefix;
    }

    private final void resize() {
        int n = this._attributeCount * 3 / 2 + 1;
        QualifiedName[] qualifiedNameArray = new QualifiedName[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        System.arraycopy(this._names, 0, qualifiedNameArray, 0, this._attributeCount);
        System.arraycopy(this._values, 0, stringArray, 0, this._attributeCount);
        System.arraycopy(this._algorithmURIs, 0, stringArray2, 0, this._attributeCount);
        System.arraycopy(this._algorithmIds, 0, nArray, 0, this._attributeCount);
        System.arraycopy(this._algorithmData, 0, objectArray, 0, this._attributeCount);
        this._names = qualifiedNameArray;
        this._values = stringArray;
        this._algorithmURIs = stringArray2;
        this._algorithmIds = nArray;
        this._algorithmData = objectArray;
    }

    private final StringBuffer convertEncodingAlgorithmDataToString(int n, String string, Object object) throws FastInfosetException, IOException {
        EncodingAlgorithm encodingAlgorithm = null;
        if (n < 9) {
            encodingAlgorithm = BuiltInEncodingAlgorithmFactory.getAlgorithm(n);
        } else {
            if (n == 9) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.CDATAAlgorithmNotSupported"));
            }
            if (n >= 32) {
                if (string == null) {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.URINotPresent") + n);
                }
                encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
                if (encodingAlgorithm == null) {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.algorithmNotRegistered") + string);
                }
            } else {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        encodingAlgorithm.convertToCharacters(object, stringBuffer);
        return stringBuffer;
    }
}

