/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;
import sun.security.krb5.internal.ktab.KeyTabEntry;

public class Ktab {
    KeyTab table;
    char action;
    String name;
    String principal;
    boolean showEType;
    boolean showTime;
    int etype = -1;
    char[] password = null;
    boolean forced = false;
    boolean append = false;
    int vDel = -1;
    int vAdd = -1;

    public static void main(String[] stringArray) {
        Ktab ktab = new Ktab();
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("-help")) {
            ktab.printHelp();
            return;
        }
        if (stringArray == null || stringArray.length == 0) {
            ktab.action = (char)108;
        } else {
            ktab.processArgs(stringArray);
        }
        try {
            if (ktab.name == null) {
                ktab.table = KeyTab.getInstance();
                if (ktab.table == null) {
                    if (ktab.action == 'a') {
                        ktab.table = KeyTab.create();
                    } else {
                        System.out.println("No default key table exists.");
                        System.exit(-1);
                    }
                }
            } else {
                if (ktab.action != 'a' && !new File(ktab.name).exists()) {
                    System.out.println("Key table " + ktab.name + " does not exist.");
                    System.exit(-1);
                } else {
                    ktab.table = KeyTab.getInstance(ktab.name);
                }
                if (ktab.table == null) {
                    if (ktab.action == 'a') {
                        ktab.table = KeyTab.create(ktab.name);
                    } else {
                        System.out.println("The format of key table " + ktab.name + " is incorrect.");
                        System.exit(-1);
                    }
                }
            }
        }
        catch (RealmException realmException) {
            System.err.println("Error loading key table.");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Error loading key table.");
            System.exit(-1);
        }
        switch (ktab.action) {
            case 'l': {
                ktab.listKt();
                break;
            }
            case 'a': {
                ktab.addEntry();
                break;
            }
            case 'd': {
                ktab.deleteEntry();
                break;
            }
            default: {
                ktab.error("A command must be provided");
            }
        }
    }

    void processArgs(String[] stringArray) {
        boolean bl = false;
        block36: for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                switch (stringArray[i].toLowerCase(Locale.US)) {
                    case "-l": {
                        this.action = (char)108;
                        break;
                    }
                    case "-a": {
                        this.action = (char)97;
                        if (++i >= stringArray.length || stringArray[i].startsWith("-")) {
                            this.error("A principal name must be specified after -a");
                        }
                        this.principal = stringArray[i];
                        break;
                    }
                    case "-d": {
                        this.action = (char)100;
                        if (++i >= stringArray.length || stringArray[i].startsWith("-")) {
                            this.error("A principal name must be specified after -d");
                        }
                        this.principal = stringArray[i];
                        break;
                    }
                    case "-e": {
                        if (this.action == 'l') {
                            this.showEType = true;
                            break;
                        }
                        if (this.action == 'd') {
                            if (++i >= stringArray.length || stringArray[i].startsWith("-")) {
                                this.error("An etype must be specified after -e");
                            }
                            try {
                                this.etype = Integer.parseInt(stringArray[i]);
                                if (this.etype > 0) continue block36;
                                throw new NumberFormatException();
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.error(stringArray[i] + " is not a valid etype");
                                break;
                            }
                        }
                        this.error(stringArray[i] + " is not valid after -" + this.action);
                        break;
                    }
                    case "-n": {
                        if (++i >= stringArray.length || stringArray[i].startsWith("-")) {
                            this.error("A KVNO must be specified after -n");
                        }
                        try {
                            this.vAdd = Integer.parseInt(stringArray[i]);
                            if (this.vAdd >= 0) continue block36;
                            throw new NumberFormatException();
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.error(stringArray[i] + " is not a valid KVNO");
                            break;
                        }
                    }
                    case "-k": {
                        if (++i >= stringArray.length || stringArray[i].startsWith("-")) {
                            this.error("A keytab name must be specified after -k");
                        }
                        if (stringArray[i].length() >= 5 && stringArray[i].substring(0, 5).equalsIgnoreCase("FILE:")) {
                            this.name = stringArray[i].substring(5);
                            break;
                        }
                        this.name = stringArray[i];
                        break;
                    }
                    case "-t": {
                        this.showTime = true;
                        break;
                    }
                    case "-f": {
                        this.forced = true;
                        break;
                    }
                    case "-append": {
                        this.append = true;
                        break;
                    }
                    default: {
                        this.error("Unknown command: " + stringArray[i]);
                    }
                }
                continue;
            }
            if (bl) {
                this.error("Useless extra argument " + stringArray[i]);
            }
            if (this.action == 'a') {
                this.password = stringArray[i].toCharArray();
            } else if (this.action == 'd') {
                switch (stringArray[i]) {
                    case "all": {
                        this.vDel = -1;
                        break;
                    }
                    case "old": {
                        this.vDel = -2;
                        break;
                    }
                    default: {
                        try {
                            this.vDel = Integer.parseInt(stringArray[i]);
                            if (this.vDel < 0) {
                                throw new NumberFormatException();
                            }
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.error(stringArray[i] + " is not a valid KVNO");
                            break;
                        }
                    }
                }
            } else {
                this.error("Useless extra argument " + stringArray[i]);
            }
            bl = true;
        }
    }

    void addEntry() {
        PrincipalName principalName = null;
        try {
            principalName = new PrincipalName(this.principal);
            if (principalName.getRealm() == null) {
                principalName.setRealm(Config.getInstance().getDefaultRealm());
            }
        }
        catch (KrbException krbException) {
            System.err.println("Failed to add " + this.principal + " to keytab.");
            krbException.printStackTrace();
            System.exit(-1);
        }
        if (this.password == null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Password for " + principalName.toString() + ":");
                System.out.flush();
                this.password = bufferedReader.readLine().toCharArray();
            }
            catch (IOException iOException) {
                System.err.println("Failed to read the password.");
                iOException.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            this.table.addEntry(principalName, this.password, this.vAdd, this.append);
            Arrays.fill(this.password, '0');
            this.table.save();
            System.out.println("Done!");
            System.out.println("Service key for " + this.principal + " is saved in " + this.table.tabName());
        }
        catch (KrbException krbException) {
            System.err.println("Failed to add " + this.principal + " to keytab.");
            krbException.printStackTrace();
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Failed to save new entry.");
            iOException.printStackTrace();
            System.exit(-1);
        }
    }

    void listKt() {
        System.out.println("Keytab name: " + this.table.tabName());
        KeyTabEntry[] keyTabEntryArray = this.table.getEntries();
        if (keyTabEntryArray != null && keyTabEntryArray.length > 0) {
            int n;
            int n2;
            String[][] stringArray = new String[keyTabEntryArray.length + 1][this.showTime ? 3 : 2];
            int n3 = 0;
            stringArray[0][n3++] = "KVNO";
            if (this.showTime) {
                stringArray[0][n3++] = "Timestamp";
            }
            stringArray[0][n3++] = "Principal";
            for (int i = 0; i < keyTabEntryArray.length; ++i) {
                n3 = 0;
                stringArray[i + 1][n3++] = keyTabEntryArray[i].getKey().getKeyVersionNumber().toString();
                if (this.showTime) {
                    stringArray[i + 1][n3++] = DateFormat.getDateTimeInstance(3, 3).format(new Date(keyTabEntryArray[i].getTimeStamp().getTime()));
                }
                String string = keyTabEntryArray[i].getService().toString();
                if (this.showEType) {
                    n2 = keyTabEntryArray[i].getKey().getEType();
                    stringArray[i + 1][n3++] = string + " (" + n2 + ":" + EType.toString(n2) + ")";
                    continue;
                }
                stringArray[i + 1][n3++] = string;
            }
            int[] nArray = new int[n3];
            for (n = 0; n < n3; ++n) {
                for (n2 = 0; n2 <= keyTabEntryArray.length; ++n2) {
                    if (stringArray[n2][n].length() <= nArray[n]) continue;
                    nArray[n] = stringArray[n2][n].length();
                }
                if (n == 0) continue;
                nArray[n] = -nArray[n];
            }
            for (n = 0; n < n3; ++n) {
                System.out.printf("%" + nArray[n] + "s ", stringArray[0][n]);
            }
            System.out.println();
            for (n = 0; n < n3; ++n) {
                for (n2 = 0; n2 < Math.abs(nArray[n]); ++n2) {
                    System.out.print("-");
                }
                System.out.print(" ");
            }
            System.out.println();
            for (n = 0; n < keyTabEntryArray.length; ++n) {
                for (n2 = 0; n2 < n3; ++n2) {
                    System.out.printf("%" + nArray[n2] + "s ", stringArray[n + 1][n2]);
                }
                System.out.println();
            }
        } else {
            System.out.println("0 entry.");
        }
    }

    void deleteEntry() {
        PrincipalName principalName = null;
        try {
            principalName = new PrincipalName(this.principal);
            if (principalName.getRealm() == null) {
                principalName.setRealm(Config.getInstance().getDefaultRealm());
            }
            if (!this.forced) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Are you sure you want to delete service key(s) for " + principalName.toString() + " (" + (this.etype == -1 ? "all etypes" : "etype=" + this.etype) + ", " + (this.vDel == -1 ? "all kvno" : (this.vDel == -2 ? "old kvno" : "kvno=" + this.vDel)) + ") in " + this.table.tabName() + "? (Y/[N]): ");
                System.out.flush();
                String string = bufferedReader.readLine();
                if (!string.equalsIgnoreCase("Y") && !string.equalsIgnoreCase("Yes")) {
                    System.exit(0);
                }
            }
        }
        catch (KrbException krbException) {
            System.err.println("Error occured while deleting the entry. Deletion failed.");
            krbException.printStackTrace();
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Error occured while deleting the entry.  Deletion failed.");
            iOException.printStackTrace();
            System.exit(-1);
        }
        int n = this.table.deleteEntries(principalName, this.etype, this.vDel);
        if (n == 0) {
            System.err.println("No matched entry in the keytab. Deletion fails.");
            System.exit(-1);
        } else {
            try {
                this.table.save();
            }
            catch (IOException iOException) {
                System.err.println("Error occurs while saving the keytab. Deletion fails.");
                iOException.printStackTrace();
                System.exit(-1);
            }
            System.out.println("Done! " + n + " entries removed.");
        }
    }

    void error(String ... stringArray) {
        for (String string : stringArray) {
            System.out.println("Error: " + string + ".");
        }
        this.printHelp();
        System.exit(-1);
    }

    void printHelp() {
        System.out.println("\nUsage: ktab <commands> <options>");
        System.out.println();
        System.out.println("Available commands:");
        System.out.println();
        System.out.println("-l [-e] [-t]\n    list the keytab name and entries. -e with etype, -t with timestamp.");
        System.out.println("-a <principal name> [<password>] [-n <kvno>] [-append]\n    add new key entries to the keytab for the given principal name with\n    optional <password>. If a <kvno> is specified, new keys' Key Version\n    Numbers equal to the value, otherwise, automatically incrementing\n    the Key Version Numbers. If -append is specified, new keys are\n    appended to the keytab, otherwise, old keys for the\n    same principal are removed.");
        System.out.println("-d <principal name> [-f] [-e <etype>] [<kvno> | all | old]\n    delete key entries from the keytab for the specified principal. If\n    <kvno> is specified, delete keys whose Key Version Numbers match\n    kvno. If \"all\" is specified, delete all keys. If \"old\" is specified,\n    delete all keys except those with the highest kvno. Default action\n    is \"all\". If <etype> is specified, only keys of this encryption type\n    are deleted. <etype> should be specified as the numberic value etype\n    defined in RFC 3961, section 8. A prompt to confirm the deletion is\n    displayed unless -f is specified.");
        System.out.println();
        System.out.println("Common option(s):");
        System.out.println();
        System.out.println("-k <keytab name>\n    specify keytab name and path with prefix FILE:");
    }
}

