/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.java2d.cmm.CMSManager;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.security.action.LoadLibraryAction;

public abstract class ColorModel
implements Transparency {
    private long pData;
    protected int pixel_bits;
    int[] nBits;
    int transparency = 3;
    boolean supportsAlpha = true;
    boolean isAlphaPremultiplied = false;
    int numComponents = -1;
    int numColorComponents = -1;
    ColorSpace colorSpace = ColorSpace.getInstance(1000);
    int colorSpaceType = 5;
    int maxBits;
    boolean is_sRGB = true;
    protected int transferType;
    private static boolean loaded = false;
    private static ColorModel RGBdefault;
    static byte[] l8Tos8;
    static byte[] s8Tol8;
    static byte[] l16Tos8;
    static short[] s8Tol16;
    static Map g8Tos8Map;
    static Map lg16Toog8Map;
    static Map g16Tos8Map;
    static Map lg16Toog16Map;

    static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new LoadLibraryAction("awt"));
            loaded = true;
        }
    }

    private static native void initIDs();

    public static ColorModel getRGBdefault() {
        if (RGBdefault == null) {
            RGBdefault = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }
        return RGBdefault;
    }

    public ColorModel(int n) {
        this.pixel_bits = n;
        if (n < 1) {
            throw new IllegalArgumentException("Number of bits must be > 0");
        }
        this.numComponents = 4;
        this.numColorComponents = 3;
        this.maxBits = n;
        this.transferType = ColorModel.getDefaultTransferType(n);
    }

    protected ColorModel(int n, int[] nArray, ColorSpace colorSpace, boolean bl, boolean bl2, int n2, int n3) {
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpace.getType();
        this.numColorComponents = colorSpace.getNumComponents();
        this.numComponents = this.numColorComponents + (bl ? 1 : 0);
        this.supportsAlpha = bl;
        if (nArray.length < this.numComponents) {
            throw new IllegalArgumentException("Number of color/alpha components should be " + this.numComponents + " but length of bits array is " + nArray.length);
        }
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException("Unknown transparency: " + n2);
        }
        if (!this.supportsAlpha) {
            this.isAlphaPremultiplied = false;
            this.transparency = 1;
        } else {
            this.isAlphaPremultiplied = bl2;
            this.transparency = n2;
        }
        this.nBits = (int[])nArray.clone();
        this.pixel_bits = n;
        if (n <= 0) {
            throw new IllegalArgumentException("Number of pixel bits must be > 0");
        }
        this.maxBits = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                throw new IllegalArgumentException("Number of bits must be >= 0");
            }
            if (this.maxBits >= nArray[i]) continue;
            this.maxBits = nArray[i];
        }
        if (this.maxBits == 0) {
            throw new IllegalArgumentException("There must be at least one component with > 0 pixel bits.");
        }
        if (colorSpace != ColorSpace.getInstance(1000)) {
            this.is_sRGB = false;
        }
        this.transferType = n3;
    }

    public final boolean hasAlpha() {
        return this.supportsAlpha;
    }

    public final boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    public final int getTransferType() {
        return this.transferType;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public int getComponentSize(int n) {
        if (this.nBits == null) {
            throw new NullPointerException("Number of bits array is null.");
        }
        return this.nBits[n];
    }

    public int[] getComponentSize() {
        if (this.nBits != null) {
            return (int[])this.nBits.clone();
        }
        return null;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getNumColorComponents() {
        return this.numColorComponents;
    }

    public abstract int getRed(int var1);

    public abstract int getGreen(int var1);

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int getRGB(int n) {
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n) << 0;
    }

    public int getRed(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getRed(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getGreen(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getGreen(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getBlue(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getBlue(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getAlpha(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getAlpha(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getRGB(Object object) {
        return this.getAlpha(object) << 24 | this.getRed(object) << 16 | this.getGreen(object) << 8 | this.getBlue(object) << 0;
    }

    public Object getDataElements(int n, Object object) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public int[] getUnnormalizedComponents(float[] fArray, int n, int[] nArray, int n2) {
        if (this.colorSpace == null) {
            throw new UnsupportedOperationException("This method is not supported by this color model.");
        }
        if (this.nBits == null) {
            throw new UnsupportedOperationException("This method is not supported.  Unable to determine #bits per component.");
        }
        if (fArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        if (nArray == null) {
            nArray = new int[n2 + this.numComponents];
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied) {
            float f = fArray[n + this.numColorComponents];
            for (int i = 0; i < this.numColorComponents; ++i) {
                nArray[n2 + i] = (int)(fArray[n + i] * (float)((1 << this.nBits[i]) - 1) * f + 0.5f);
            }
            nArray[n2 + this.numColorComponents] = (int)(f * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
        } else {
            for (int i = 0; i < this.numComponents; ++i) {
                nArray[n2 + i] = (int)(fArray[n + i] * (float)((1 << this.nBits[i]) - 1) + 0.5f);
            }
        }
        return nArray;
    }

    public float[] getNormalizedComponents(int[] nArray, int n, float[] fArray, int n2) {
        if (this.colorSpace == null) {
            throw new UnsupportedOperationException("This method is not supported by this color model.");
        }
        if (this.nBits == null) {
            throw new UnsupportedOperationException("This method is not supported.  Unable to determine #bits per component.");
        }
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        if (fArray == null) {
            fArray = new float[this.numComponents + n2];
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied) {
            float f = nArray[n + this.numColorComponents];
            if ((f /= (float)((1 << this.nBits[this.numColorComponents]) - 1)) != 0.0f) {
                for (int i = 0; i < this.numColorComponents; ++i) {
                    fArray[n2 + i] = (float)nArray[n + i] / (f * (float)((1 << this.nBits[i]) - 1));
                }
            } else {
                for (int i = 0; i < this.numColorComponents; ++i) {
                    fArray[n2 + i] = 0.0f;
                }
            }
            fArray[n2 + this.numColorComponents] = f;
        } else {
            for (int i = 0; i < this.numComponents; ++i) {
                fArray[n2 + i] = (float)nArray[n + i] / (float)((1 << this.nBits[i]) - 1);
            }
        }
        return fArray;
    }

    public int getDataElement(int[] nArray, int n) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        throw new UnsupportedOperationException("This method has not been implemented for this color model.");
    }

    public int getDataElement(float[] fArray, int n) {
        int[] nArray = this.getUnnormalizedComponents(fArray, n, null, 0);
        return this.getDataElement(nArray, 0);
    }

    public Object getDataElements(float[] fArray, int n, Object object) {
        int[] nArray = this.getUnnormalizedComponents(fArray, n, null, 0);
        return this.getDataElements(nArray, 0, object);
    }

    public float[] getNormalizedComponents(Object object, float[] fArray, int n) {
        int[] nArray = this.getComponents(object, null, 0);
        return this.getNormalizedComponents(nArray, 0, fArray, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorModel)) {
            return false;
        }
        ColorModel colorModel = (ColorModel)object;
        if (this == colorModel) {
            return true;
        }
        if (this.supportsAlpha != colorModel.hasAlpha() || this.isAlphaPremultiplied != colorModel.isAlphaPremultiplied() || this.pixel_bits != colorModel.getPixelSize() || this.transparency != colorModel.getTransparency() || this.numComponents != colorModel.getNumComponents()) {
            return false;
        }
        int[] nArray = colorModel.getComponentSize();
        if (this.nBits != null && nArray != null) {
            for (int i = 0; i < this.numComponents; ++i) {
                if (this.nBits[i] == nArray[i]) continue;
                return false;
            }
        } else {
            return this.nBits == null && nArray == null;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        n = (this.supportsAlpha ? 2 : 3) + (this.isAlphaPremultiplied ? 4 : 5) + this.pixel_bits * 6 + this.transparency * 7 + this.numComponents * 8;
        if (this.nBits != null) {
            for (int i = 0; i < this.numComponents; ++i) {
                n += this.nBits[i] * (i + 9);
            }
        }
        return n;
    }

    public final ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public boolean isCompatibleRaster(Raster raster) {
        throw new UnsupportedOperationException("This method has not been implemented for this ColorModel.");
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public void finalize() {
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        return null;
    }

    public String toString() {
        return new String("ColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.colorSpace + " transparency = " + this.transparency + " has alpha = " + this.supportsAlpha + " isAlphaPre = " + this.isAlphaPremultiplied);
    }

    static int getDefaultTransferType(int n) {
        if (n <= 8) {
            return 0;
        }
        if (n <= 16) {
            return 1;
        }
        if (n <= 32) {
            return 3;
        }
        return 32;
    }

    static boolean isLinearRGBspace(ColorSpace colorSpace) {
        return colorSpace == CMSManager.LINEAR_RGBspace;
    }

    static boolean isLinearGRAYspace(ColorSpace colorSpace) {
        return colorSpace == CMSManager.GRAYspace;
    }

    static byte[] getLinearRGB8TosRGB8LUT() {
        if (l8Tos8 == null) {
            l8Tos8 = new byte[256];
            for (int i = 0; i <= 255; ++i) {
                float f = (float)i / 255.0f;
                float f2 = f <= 0.0031308f ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
                ColorModel.l8Tos8[i] = (byte)Math.round(f2 * 255.0f);
            }
        }
        return l8Tos8;
    }

    static byte[] getsRGB8ToLinearRGB8LUT() {
        if (s8Tol8 == null) {
            s8Tol8 = new byte[256];
            for (int i = 0; i <= 255; ++i) {
                float f = (float)i / 255.0f;
                float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow((f + 0.055f) / 1.055f, 2.4);
                ColorModel.s8Tol8[i] = (byte)Math.round(f2 * 255.0f);
            }
        }
        return s8Tol8;
    }

    static byte[] getLinearRGB16TosRGB8LUT() {
        if (l16Tos8 == null) {
            l16Tos8 = new byte[65536];
            for (int i = 0; i <= 65535; ++i) {
                float f = (float)i / 65535.0f;
                float f2 = f <= 0.0031308f ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
                ColorModel.l16Tos8[i] = (byte)Math.round(f2 * 255.0f);
            }
        }
        return l16Tos8;
    }

    static short[] getsRGB8ToLinearRGB16LUT() {
        if (s8Tol16 == null) {
            s8Tol16 = new short[256];
            for (int i = 0; i <= 255; ++i) {
                float f = (float)i / 255.0f;
                float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow((f + 0.055f) / 1.055f, 2.4);
                ColorModel.s8Tol16[i] = (short)Math.round(f2 * 65535.0f);
            }
        }
        return s8Tol16;
    }

    static byte[] getGray8TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        byte[] byArray;
        if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
            return ColorModel.getLinearRGB8TosRGB8LUT();
        }
        if (g8Tos8Map != null && (byArray = (byte[])g8Tos8Map.get(iCC_ColorSpace)) != null) {
            return byArray;
        }
        byArray = new byte[256];
        for (int i = 0; i <= 255; ++i) {
            byArray[i] = (byte)i;
        }
        ColorTransform[] colorTransformArray = new ColorTransform[2];
        PCMM pCMM = CMSManager.getModule();
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        colorTransformArray[0] = pCMM.createTransform(iCC_ColorSpace.getProfile(), -1, 1);
        colorTransformArray[1] = pCMM.createTransform(iCC_ColorSpace2.getProfile(), -1, 2);
        ColorTransform colorTransform = pCMM.createTransform(colorTransformArray);
        byte[] byArray2 = colorTransform.colorConvert(byArray, (byte[])null);
        int n = 0;
        int n2 = 2;
        while (n <= 255) {
            byArray[n] = byArray2[n2];
            ++n;
            n2 += 3;
        }
        if (g8Tos8Map == null) {
            g8Tos8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        g8Tos8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static byte[] getLinearGray16ToOtherGray8LUT(ICC_ColorSpace iCC_ColorSpace) {
        Object[] objectArray;
        if (lg16Toog8Map != null && (objectArray = (Object[])((byte[])lg16Toog8Map.get(iCC_ColorSpace))) != null) {
            return objectArray;
        }
        objectArray = new short[65536];
        for (int i = 0; i <= 65535; ++i) {
            objectArray[i] = (short)i;
        }
        ColorTransform[] colorTransformArray = new ColorTransform[2];
        PCMM pCMM = CMSManager.getModule();
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1003);
        colorTransformArray[0] = pCMM.createTransform(iCC_ColorSpace2.getProfile(), -1, 1);
        colorTransformArray[1] = pCMM.createTransform(iCC_ColorSpace.getProfile(), -1, 2);
        ColorTransform colorTransform = pCMM.createTransform(colorTransformArray);
        objectArray = colorTransform.colorConvert((short[])objectArray, null);
        byte[] byArray = new byte[65536];
        for (int i = 0; i <= 65535; ++i) {
            byArray[i] = (byte)((float)(objectArray[i] & 0xFFFF) * 0.0038910506f + 0.5f);
        }
        if (lg16Toog8Map == null) {
            lg16Toog8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        lg16Toog8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static byte[] getGray16TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        Object[] objectArray;
        if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
            return ColorModel.getLinearRGB16TosRGB8LUT();
        }
        if (g16Tos8Map != null && (objectArray = (Object[])((byte[])g16Tos8Map.get(iCC_ColorSpace))) != null) {
            return objectArray;
        }
        objectArray = new short[65536];
        for (int i = 0; i <= 65535; ++i) {
            objectArray[i] = (short)i;
        }
        ColorTransform[] colorTransformArray = new ColorTransform[2];
        PCMM pCMM = CMSManager.getModule();
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        colorTransformArray[0] = pCMM.createTransform(iCC_ColorSpace.getProfile(), -1, 1);
        colorTransformArray[1] = pCMM.createTransform(iCC_ColorSpace2.getProfile(), -1, 2);
        ColorTransform colorTransform = pCMM.createTransform(colorTransformArray);
        objectArray = colorTransform.colorConvert((short[])objectArray, null);
        byte[] byArray = new byte[65536];
        int n = 0;
        int n2 = 2;
        while (n <= 65535) {
            byArray[n] = (byte)((float)(objectArray[n2] & 0xFFFF) * 0.0038910506f + 0.5f);
            ++n;
            n2 += 3;
        }
        if (g16Tos8Map == null) {
            g16Tos8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        g16Tos8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static short[] getLinearGray16ToOtherGray16LUT(ICC_ColorSpace iCC_ColorSpace) {
        short[] sArray;
        if (lg16Toog16Map != null && (sArray = (short[])lg16Toog16Map.get(iCC_ColorSpace)) != null) {
            return sArray;
        }
        sArray = new short[65536];
        for (int i = 0; i <= 65535; ++i) {
            sArray[i] = (short)i;
        }
        ColorTransform[] colorTransformArray = new ColorTransform[2];
        PCMM pCMM = CMSManager.getModule();
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1003);
        colorTransformArray[0] = pCMM.createTransform(iCC_ColorSpace2.getProfile(), -1, 1);
        colorTransformArray[1] = pCMM.createTransform(iCC_ColorSpace.getProfile(), -1, 2);
        ColorTransform colorTransform = pCMM.createTransform(colorTransformArray);
        short[] sArray2 = colorTransform.colorConvert(sArray, null);
        if (lg16Toog16Map == null) {
            lg16Toog16Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        lg16Toog16Map.put(iCC_ColorSpace, sArray2);
        return sArray2;
    }

    static {
        ColorModel.loadLibraries();
        ColorModel.initIDs();
        l8Tos8 = null;
        s8Tol8 = null;
        l16Tos8 = null;
        s8Tol16 = null;
        g8Tos8Map = null;
        lg16Toog8Map = null;
        g16Tos8Map = null;
        lg16Toog16Map = null;
    }
}

