/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.DialogTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public abstract class BasicDialog
extends JDialog {
    private final boolean setCancelToDefault;
    private JButton cancelButton;

    public BasicDialog(JFrame jFrame, String string, boolean bl) {
        super(jFrame, string, true);
        this.setCancelToDefault = bl;
        this.initComponents();
    }

    public BasicDialog(JFrame jFrame, String string) {
        this(jFrame, string, false);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BasicDialog.this.closeDialog();
            }
        });
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(new Insets(16, 16, 10, 10)));
        jPanel.add((Component)this.createContentPanel(), "Center");
        jPanel.add((Component)this.createOkCancelPanel(), "South");
        this.add(jPanel);
        this.pack();
        this.setResizable(false);
    }

    protected abstract void okAction();

    protected abstract JComponent createContentPanel();

    protected void cancelAction() {
        this.closeDialog();
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    protected static JButton makeButton(String string) {
        JButton jButton = new JButton(BasicDialog.getMessage(string));
        return jButton;
    }

    protected JComponent createOkCancelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = BasicDialog.makeButton("common.ok_btn");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicDialog.this.okAction();
            }
        });
        jPanel.add(jButton);
        this.cancelButton = BasicDialog.makeButton("common.cancel_btn");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicDialog.this.cancelAction();
            }
        };
        this.cancelButton.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        JButton[] jButtonArray = new JButton[]{jButton, this.cancelButton};
        DialogTemplate.resizeButtons(jButtonArray);
        jPanel.add(this.cancelButton);
        if (this.setCancelToDefault) {
            this.getRootPane().setDefaultButton(this.cancelButton);
            this.cancelButton.requestFocusInWindow();
        } else {
            this.getRootPane().setDefaultButton(jButton);
            jButton.requestFocusInWindow();
        }
        this.enterPressesWhenFocused(jButton);
        this.enterPressesWhenFocused(this.cancelButton);
        return jPanel;
    }

    public void pack() {
        super.pack();
        if (this.setCancelToDefault) {
            this.cancelButton.requestFocusInWindow();
        }
    }

    private void enterPressesWhenFocused(JButton jButton) {
        jButton.registerKeyboardAction(jButton.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        jButton.registerKeyboardAction(jButton.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }
}

